/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.vmanager.streamProxy;

import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.media.zlm.dto.MediaServerItem;
import com.genersoft.iot.vmp.media.zlm.dto.StreamProxyItem;
import com.genersoft.iot.vmp.service.IMediaServerService;
import com.genersoft.iot.vmp.service.IStreamProxyService;
import com.genersoft.iot.vmp.storager.IRedisCatchStorage;
import com.genersoft.iot.vmp.vmanager.bean.WVPResult;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u62c9\u6d41\u4ee3\u7406"})
@Controller
@CrossOrigin
@RequestMapping(value={"/api/proxy"})
public class StreamProxyController {
    private static final Logger logger = LoggerFactory.getLogger(StreamProxyController.class);
    @Autowired
    private IRedisCatchStorage redisCatchStorage;
    @Autowired
    private IMediaServerService mediaServerService;
    @Autowired
    private IStreamProxyService streamProxyService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d41\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="count", value="\u6bcf\u9875\u67e5\u8be2\u6570\u91cf", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="query", value="\u67e5\u8be2\u5185\u5bb9", dataTypeClass=String.class), @ApiImplicitParam(name="online", value="\u662f\u5426\u5728\u7ebf", dataTypeClass=Boolean.class)})
    @GetMapping(value={"/list"})
    @ResponseBody
    public PageInfo<StreamProxyItem> list(@RequestParam(required=false) Integer page, @RequestParam(required=false) Integer count, @RequestParam(required=false) String query, @RequestParam(required=false) Boolean online) {
        return this.streamProxyService.getAll(page, count);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="param", value="\u4ee3\u7406\u53c2\u6570", dataTypeClass=StreamProxyItem.class)})
    @PostMapping(value={"/save"})
    @ResponseBody
    public WVPResult save(@RequestBody StreamProxyItem param) {
        logger.info("\u6dfb\u52a0\u4ee3\u7406\uff1a " + JSONObject.toJSONString((Object)param));
        if (StringUtils.isEmpty((Object)param.getMediaServerId())) {
            param.setMediaServerId("auto");
        }
        String msg = this.streamProxyService.save(param);
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg(msg);
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6ffmpeg.cmd\u6a21\u677f")
    @GetMapping(value={"/ffmpeg_cmd/list"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="mediaServerId", value="\u6d41\u5a92\u4f53ID", dataTypeClass=String.class)})
    @ResponseBody
    public WVPResult getFFmpegCMDs(@RequestParam String mediaServerId) {
        logger.debug("\u83b7\u53d6\u8282\u70b9[ {} ]ffmpeg.cmd\u6a21\u677f", (Object)mediaServerId);
        MediaServerItem mediaServerItem = this.mediaServerService.getOne(mediaServerId);
        JSONObject data = this.streamProxyService.getFFmpegCMDs(mediaServerItem);
        WVPResult result = new WVPResult();
        result.setCode(0);
        result.setMsg("success");
        result.setData((Object)data);
        return result;
    }

    @ApiOperation(value="\u79fb\u9664\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="app", value="\u5e94\u7528\u540d", required=true, dataTypeClass=String.class), @ApiImplicitParam(name="stream", value="\u6d41ID", required=true, dataTypeClass=String.class)})
    @DeleteMapping(value={"/del"})
    @ResponseBody
    public WVPResult del(@RequestParam String app, @RequestParam String stream) {
        logger.info("\u79fb\u9664\u4ee3\u7406\uff1a " + app + "/" + stream);
        WVPResult result = new WVPResult();
        if (app == null || stream == null) {
            result.setCode(400);
            result.setMsg(app == null ? "app\u4e0d\u80fd\u4e3anull" : "stream\u4e0d\u80fd\u4e3anull");
        } else {
            this.streamProxyService.del(app, stream);
            result.setCode(0);
            result.setMsg("success");
        }
        return result;
    }

    @ApiOperation(value="\u542f\u7528\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="app", value="\u5e94\u7528\u540d", dataTypeClass=String.class), @ApiImplicitParam(name="stream", value="\u6d41ID", dataTypeClass=String.class)})
    @GetMapping(value={"/start"})
    @ResponseBody
    public Object start(String app, String stream) {
        logger.info("\u542f\u7528\u4ee3\u7406\uff1a " + app + "/" + stream);
        boolean result = this.streamProxyService.start(app, stream);
        return result ? "success" : "fail";
    }

    @ApiOperation(value="\u505c\u7528\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="app", value="\u5e94\u7528\u540d", dataTypeClass=String.class), @ApiImplicitParam(name="stream", value="\u6d41ID", dataTypeClass=String.class)})
    @GetMapping(value={"/stop"})
    @ResponseBody
    public Object stop(String app, String stream) {
        logger.info("\u505c\u7528\u4ee3\u7406\uff1a " + app + "/" + stream);
        boolean result = this.streamProxyService.stop(app, stream);
        return result ? "success" : "fail";
    }
}

