/*
 * Decompiled with CFR 0.152.
 */
package com.genersoft.iot.vmp.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.genersoft.iot.vmp.gb28181.bean.Device;
import com.genersoft.iot.vmp.gb28181.bean.DeviceChannel;
import com.genersoft.iot.vmp.storager.IVideoManagerStorager;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/v1/device"})
public class ApiDeviceController {
    private static final Logger logger = LoggerFactory.getLogger(ApiDeviceController.class);
    @Autowired
    private IVideoManagerStorager storager;

    @RequestMapping(value={"/list"})
    public JSONObject list(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String q, @RequestParam(required=false) Boolean online) {
        List devices;
        JSONObject result = new JSONObject();
        if (start == null || limit == null) {
            devices = this.storager.queryVideoDeviceList();
            result.put("DeviceCount", (Object)devices.size());
        } else {
            PageInfo deviceList = this.storager.queryVideoDeviceList(start / limit, limit.intValue());
            result.put("DeviceCount", (Object)deviceList.getTotal());
            devices = deviceList.getList();
        }
        JSONArray deviceJSONList = new JSONArray();
        for (Device device : devices) {
            JSONObject deviceJsonObject = new JSONObject();
            deviceJsonObject.put("ID", (Object)device.getDeviceId());
            deviceJsonObject.put("Name", (Object)device.getName());
            deviceJsonObject.put("Type", (Object)"GB");
            deviceJsonObject.put("ChannelCount", (Object)device.getChannelCount());
            deviceJsonObject.put("RecvStreamIP", (Object)"");
            deviceJsonObject.put("CatalogInterval", (Object)3600);
            deviceJsonObject.put("SubscribeInterval", (Object)0);
            deviceJsonObject.put("Online", (Object)(device.getOnline() == 1 ? 1 : 0));
            deviceJsonObject.put("Password", (Object)"");
            deviceJsonObject.put("MediaTransport", (Object)device.getTransport());
            deviceJsonObject.put("RemoteIP", (Object)device.getIp());
            deviceJsonObject.put("RemotePort", (Object)device.getPort());
            deviceJsonObject.put("LastRegisterAt", (Object)"");
            deviceJsonObject.put("LastKeepaliveAt", (Object)"");
            deviceJsonObject.put("UpdatedAt", (Object)"");
            deviceJsonObject.put("CreatedAt", (Object)"");
            deviceJSONList.add((Object)deviceJsonObject);
        }
        result.put("DeviceList", (Object)deviceJSONList);
        return result;
    }

    @RequestMapping(value={"/channellist"})
    public JSONObject channellist(String serial, @RequestParam(required=false) String channel_type, @RequestParam(required=false) String dir_serial, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String q, @RequestParam(required=false) Boolean online) {
        List deviceChannels;
        JSONObject result = new JSONObject();
        Device device = this.storager.queryVideoDevice(serial);
        if (device == null) {
            result.put("ChannelCount", (Object)0);
            result.put("ChannelList", (Object)"[]");
            return result;
        }
        if (start == null || limit == null) {
            deviceChannels = this.storager.queryChannelsByDeviceId(serial);
            result.put("ChannelCount", (Object)deviceChannels.size());
        } else {
            PageInfo pageResult = this.storager.queryChannelsByDeviceId(serial, null, null, null, start / limit, limit.intValue());
            result.put("ChannelCount", (Object)pageResult.getTotal());
            deviceChannels = pageResult.getList();
        }
        JSONArray channleJSONList = new JSONArray();
        for (DeviceChannel deviceChannel : deviceChannels) {
            JSONObject deviceJOSNChannel = new JSONObject();
            deviceJOSNChannel.put("ID", (Object)deviceChannel.getChannelId());
            deviceJOSNChannel.put("DeviceID", (Object)device.getDeviceId());
            deviceJOSNChannel.put("DeviceName", (Object)device.getName());
            deviceJOSNChannel.put("DeviceOnline", (Object)(device.getOnline() == 1 ? 1 : 0));
            deviceJOSNChannel.put("Channel", (Object)0);
            deviceJOSNChannel.put("Name", (Object)deviceChannel.getName());
            deviceJOSNChannel.put("Custom", (Object)false);
            deviceJOSNChannel.put("CustomName", (Object)"");
            deviceJOSNChannel.put("SubCount", (Object)deviceChannel.getSubCount());
            deviceJOSNChannel.put("SnapURL", (Object)"");
            deviceJOSNChannel.put("Manufacturer ", (Object)deviceChannel.getManufacture());
            deviceJOSNChannel.put("Model", (Object)deviceChannel.getModel());
            deviceJOSNChannel.put("Owner", (Object)deviceChannel.getOwner());
            deviceJOSNChannel.put("CivilCode", (Object)deviceChannel.getCivilCode());
            deviceJOSNChannel.put("Address", (Object)deviceChannel.getAddress());
            deviceJOSNChannel.put("Parental", (Object)deviceChannel.getParental());
            deviceJOSNChannel.put("ParentID", (Object)deviceChannel.getParentId());
            deviceJOSNChannel.put("Secrecy", (Object)deviceChannel.getSecrecy());
            deviceJOSNChannel.put("RegisterWay", (Object)1);
            deviceJOSNChannel.put("Status", (Object)deviceChannel.getStatus());
            deviceJOSNChannel.put("Longitude", (Object)deviceChannel.getLongitude());
            deviceJOSNChannel.put("Latitude", (Object)deviceChannel.getLatitude());
            deviceJOSNChannel.put("PTZType ", (Object)deviceChannel.getPTZType());
            deviceJOSNChannel.put("CustomPTZType", (Object)"");
            deviceJOSNChannel.put("StreamID", (Object)deviceChannel.getStreamId());
            deviceJOSNChannel.put("NumOutputs ", (Object)-1);
            channleJSONList.add((Object)deviceJOSNChannel);
        }
        result.put("ChannelList", (Object)channleJSONList);
        return result;
    }
}

